﻿// This is from the sample code provided in the Visual Studio
// Documentation. It presents information related to the
// resolution and frequency available via the Stopwatch class
// on your system. I have added comments to the code.

using System;
using System.Diagnostics;

namespace StopwatchInformation {
  class Program {
    static void Main(string[] args) {
      // determine if the timer is a high-resolution timer
      // IsHighResolution is a static field
      if (Stopwatch.IsHighResolution) {
        Console.WriteLine("Operations timed using the system's " + 
                          "high-resolution performance counter.");
      }
      else {
        Console.WriteLine("Operations timed using the " +
                          "DateTime class.");
      }

      // get the frequency for the timer in ticks per second
      // Frequency is a static field
      Int64 frequency = Stopwatch.Frequency;
 
      // display the frequency
      Console.WriteLine("  Timer frequency in ticks per second = {0}",
                        frequency);

      // calculate the resolution in nanoseconds
      // 1 billion nanoseconds = 1 second
      // so, here we have 1 billion / ticks per second
      Int64 nanosecPerTick = (1000000000) / frequency;

      // display the resolution
      Console.WriteLine("  Timer is accurate within {0} nanoseconds",
                        nanosecPerTick);
    }
  }
}
