﻿// This sample is designed to approximate the cost of
// invoking a pair of Stopwatch start and stop methods.

using System;
using System.Diagnostics;

namespace StopwatchCost {
  class Program {
    static void Main(string[] args) {
      // the stop watches for timing
      Stopwatch sw1 = new Stopwatch();
      Stopwatch sw2 = new Stopwatch();

      // start the "primary" stopwatch
      sw1.Start();

      // invoke a pair of start/stop methods
      // for 1,000,000 iterations.
      // of course this includes the for loop
      for (int i = 0; i < 1000001; i++) {
        sw2.Start();
        sw2.Stop();
      }

      // stop the "primary" stopwatch
      sw1.Stop();

      // display the average duration in milliseconds
      Console.WriteLine("Average duration: {0} ms",
        (double)sw1.ElapsedMilliseconds/1000000);
    }
  }
}
