﻿// this sample illustrates getting the processor
// time values from the Process class

using System;
using System.Diagnostics;
using System.IO;

namespace CPUTime {
  class Program {
    static void Main(string[] args) {
      // used in loop below
      int dummy = 0;
      long square = 0;
      string fname = "test.txt";

      // holds the start processor time values
      TimeSpan tsTotalStart = new TimeSpan();
      TimeSpan tsPrivilegedStart = new TimeSpan();
      TimeSpan tsUserStart = new TimeSpan();

      // holds the end processor time values
      TimeSpan tsTotalEnd = new TimeSpan();
      TimeSpan tsPrivilegedEnd = new TimeSpan();
      TimeSpan tsUserEnd = new TimeSpan();
      
      // get the current process
      Process p = Process.GetCurrentProcess();

      // get current processor values (start)
      tsTotalStart = p.TotalProcessorTime;
      tsPrivilegedStart = p.PrivilegedProcessorTime;
      tsUserStart = p.UserProcessorTime;

      // perform cpu and kernel operations in loop
      for (int i = 0; i < 1000; i++) {
        if (!File.Exists(fname)) {
          using (StreamWriter sw = File.CreateText(fname)) {
            sw.WriteLine("Hello, world!");
          }
        }

        File.Delete(fname);
        
        square = dummy * dummy;
      }

      // get current processor values (end)
      tsTotalEnd = p.TotalProcessorTime;
      tsPrivilegedEnd = p.PrivilegedProcessorTime;
      tsUserEnd = p.UserProcessorTime;

      // display results
      Console.WriteLine("     Total Processor Time: {0} ms",
        (tsTotalEnd - tsTotalStart).Milliseconds);

      Console.WriteLine("Privileged Processor Time: {0} ms",
        (tsPrivilegedEnd - tsPrivilegedStart).Milliseconds);

      Console.WriteLine("      User Processor Time: {0} ms",
        (tsUserEnd - tsUserStart).Milliseconds);
    }
  }
}
